
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PWMAPLIB_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PWMAPLIB_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifndef PWInt16
typedef short PWInt16;
typedef long PWInt32;
typedef unsigned short PWUInt16;
typedef unsigned long PWUInt32;
#endif


#ifdef PWMAPLIB_EXPORTS
#define PWMAPLIB_API __declspec(dllexport)
#else
#define PWMAPLIB_API __declspec(dllimport)
#endif

typedef PWInt32 PWProgressCallback(PWInt32 strID, PWInt32 num, PWInt32 total, void *pvSession);
typedef PWProgressCallback *PWProgressCallbackPtr;

typedef PWInt32 (*PWSetProgressCallbackProcType)(PWProgressCallbackPtr pProgressFunc);

typedef PWInt32 (*PWMapConvertProcType)(char *, char *, PWInt16, PWInt16, PWInt32, PWInt32, PWInt32, 
								  PWInt32, char *, char *, char *, char *, PWInt32, PWInt32, PWInt32, 
								  PWUInt16, PWUInt16);
typedef PWInt32 (*PWCalMapConvertProcType)(char *, char *, char *, char *, char *,
											 PWInt16 , PWInt16 , 
											 PWInt16 , PWInt16 , PWInt16 , PWInt16 ,
												PWInt32, PWInt32 , PWInt32 , PWUInt16 , PWUInt16 );

typedef PWInt32 (*PWQVMapConvertProcType)(char *, char *, PWInt16, PWInt16, char *);
typedef PWInt32 (*PWQVWinMobileMapConvertProcType)(char *, char *, PWInt16, PWInt16, char *);

typedef PWInt32 (*PWSetSessionPtrProcType)(void *);
typedef PWInt32 (*PWMapSetUserIDProcType)(char *userID);

PWMAPLIB_API PWInt32 
PWMapConvert(char *fileName, char *PalmMapName, PWInt16 maxImageDepth, PWInt16 compression, 
	   PWInt16 leftMargin, PWInt16 topMargin, PWInt16 rightMargin, PWInt16 bottomMargin,
	   char *pLocLatTL, char *pLocLongTL, char *pLocLatBR, char *pLocLongBR, 
	   PWInt32 GridCount, PWInt32 GridGenX, PWInt32 GridGenY, PWUInt16 scaleMul, PWUInt16 scaleDiv);

PWMAPLIB_API PWInt32 
PWCalMapConvert(char *fileName, char *PalmMapName, char *calFileName, char *natGridID, char *encodeStr,
	 PWInt16 maxImageDepth, PWInt16 compression, 
	 PWInt16 leftMargin, PWInt16 topMargin, PWInt16 rightMargin, PWInt16 bottomMargin,
		PWInt32 GridCount, PWInt32 GridGenX, PWInt32 GridGenY, PWUInt16 scaleMul, PWUInt16 scaleDiv);


PWMAPLIB_API PWInt32 
PWQVMapConvert(char *fileName, char *PalmMapName, PWInt16 maxImageDepth, PWInt16 compression, 
			   char *pMapDefinition);

PWMAPLIB_API PWInt32 
PWQVWinMobileMapConvert(char *fileName, char *WMMapName, PWInt16 maxImageDepth, PWInt16 compression, char *pMapDefinition);

PWMAPLIB_API PWInt32 
PWMapSetProgressCallback(PWProgressCallbackPtr pProgressFunc);

PWMAPLIB_API PWInt32 
PWMapSetSessionPtr(void *pvSession);

PWMAPLIB_API PWInt32 
PWMapSetUserID(char *userID);
