// PWDBLIB.H : Defines the entry point and definitions for the DLL application.
//
#define PW_DELIMITED_COMMA	0
#define DELIMITED_COMMA	1
#define DELIMITED_TAB	2
#define GARMIN_TAB	3
#define TEXTFILE	4	// Raw Record Translation, Records <CR> Delimited
#define FIXEDLEN	5	// fixed len, <CR> Record Delimeter. FieldLen param must be in CAL file
#define PCX5		6
#define XMLFILE		7	
#define LOCFILE		8
#define GPXFILE		9
#define KMLFILE		10
#define DELIMITED_OTHER 11

#define PWDBTYPE_POINT 0
#define PWDBTYPE_TRACK 1
#define PWDBTYPE_ROUTE 2
#define PWDBTYPE_LOG 3
#define PWDBTYPE_VMAP 4
#define PWDBTYPE_VMAPDBF 5
#define PWDBTYPE_DATUMGRID 6
#define PWDBTYPE_XMLDATA 7
#define PWDBTYPE_MAP	8
#define PWDBTYPE_ICON	9
#define PWDBTYPE_MAPPRC	10
#define PWDBTYPE_PWPDB	11

#define PWDBTYPE_UNKNOWN 0xFFFF

#define PWDBTYPE_TRACK2 0x41
#define PWDBTYPE_ROUTE2 0x42

// CE Commands for Copying between devices
#define DBCOPY_OVERWRITE		1
#define DBCOPY_UPDATENEW		2
#define DBCOPY_ADDONLY			4
#define DBCOPY_ASK				8
#define DBCOPY_RENAME			0x10
#define DBCOPY_CREATEVOLUME		0x20

#define DBCOPY_DELETESOURCEAFTER		0x40
#define DBCOPY_DLATTACHMENTS	0x80
//System Flags 0x1000 and higher

// Returns >= 0 something successfully done
// Return Status codes
#define PWDBSTAT_SUCCESS		0				// success
#define PWDBSTAT_ADDED			0				// Database was added
#define PWDBSTAT_OVERWRITTEN	0x07000001	// Database was overwritted
#define PWDBSTAT_EXISTS			0x07000002	// Already Exists
#define PWDBSTAT_UPTODATE		0x07000003	// identical
#define PWDBSTAT_EXISTSNEWER	0x07000012	// nothing done, all is OK
#define PWDBSTAT_EXISTSOLDER	0x07000022	// nothing done, all is OK

// Returns Status Helper Macros
#define PWDB_SUCCESS(err)	((err) >= 0)				// success
#define PWDB_ADDED(err)		((err) == 0)				// Database was added
#define PWDB_OVERWRITTEN(err)	((err) == 0x07000001)	// Database was overwritted
#define PWDB_WRITTEN(err)	(((err)==0) || (err) == 0x07000001)	// Database was overwritted
#define PWDB_EXISTS(err)			(((err)&0xFFFFFF0F) == 0x07000002)	// nothing done, already exists
#define PWDB_UPTODATE(err)		((err) == 0x07000003)	// nothing done, both are identical 
#define PWDB_EXISTSNEWER(err)	((err) == 0x07000012)	// nothing done, target db is newer
#define PWDB_EXISTSOLDER(err)	((err) == 0x07000022)	// nothing done, target db is older

// Returns < 0 error(s) occurred
// Return Error codes
#define PWERR_FAILED(err)			((err) < 0) // "Failure"
#define PWERR_CONNECTIONTIMEOUT		-7 // "Timeout Connecting to Device"
#define PWERR_CONNECTIONFAILED		-8 // "Can't Connect to Device"
#define PWERR_USERABORT				-9	// User Aborted
#define PWERR_COULDNOTMOUNTVOLUME	-10	// Could Not Create Database Volume on Device
#define PWERR_UKNOWNDATATYPE		-11	// User Aborted
#define PWERR_FILENOTFOUND			-12

#ifndef PWInt16
typedef short PWInt16;
typedef long PWInt32;
typedef unsigned short PWUInt16;
typedef unsigned long PWUInt32;
#endif


// Structures used for PWDBReadPDB, PWDBWritePDB
// PWDBLib uses 2-byte Structure Alignment
typedef struct {
	PWInt16 iFlags;
	PWInt32 iLat;
	PWInt32 iLong;
	PWInt32 iEle;
	PWInt32 iTime;
	PWInt32 iNMDist;
}PWPointInfoBinaryData;

// Main Structure for PWDBReadPDB, PWDBWritePDB
typedef struct {
	char strPointName[256];
	char strLatitude[32];
	char strLongitude[32];
	char strUTCTime[32];
	char strElevation[32];
	char strIconID[256];
	char strUnused[28];
	PWInt32 desclen;	// New, size of desclen
	char *descstr;	// may be NULL
	BOOL hasBin;	// Flag Indicating Binary Data is valid
	PWPointInfoBinaryData binData;
}PWPointInfoData;


// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PWDBLIB_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PWDBLIB_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef PWDBLIB_EXPORTS
#define PWDBLIB_API __declspec(dllexport)
#else
#define PWDBLIB_API __declspec(dllimport)
#endif

// Import/Export
typedef PWInt32 (*PWDBImportProcType)(char *, char *, char *, PWInt16, PWInt16, PWInt16, PWInt16 *);
typedef PWInt32 (*PWDBExportProcType)(char *, char *, char *, PWInt16, PWInt16, PWInt16, PWInt16 *);
typedef PWInt32 (*PWDBImportMultiProcType)(char *, char *, PWInt16, PWInt16, PWInt16, PWInt16 *, char ***, int *);

// To .pwx
typedef PWInt32 (*PWDBImportToPWXProcType)(char *, char *, char *, PWInt16, PWInt16, PWInt16, PWInt16 *);

// Pocket PC
typedef PWInt32 (*PWDBCEEnumProcType)( char *, char *, PWUInt32 , void *);
typedef PWInt32 (*PWDBCECopyToDeviceProcType)( char *, char *, PWUInt32);
typedef PWInt32 (*PWDBCECopyFromDeviceProcType)( char *, char *, char *, PWUInt32);

// Callbacks
typedef PWInt32 __stdcall PWProgressCallback(PWInt32 strID, PWInt32 num, PWInt32 total, char *pszDesc, void *pvSession);
typedef PWProgressCallback *PWProgressCallbackPtr;
typedef PWInt32 (*PWSetProgressCallbackProcType)(PWProgressCallbackPtr pProgressFunc);

typedef PWInt32 (*PWSetSessionPtrProcType)(void *);

// File Comparison flags
#define PWDBCOMPARE_IDENTICAL	0x07000003	// identical
#define PWDBCOMPARE_EXISTSNEWER	0x07000012	// Destination is Newer
#define PWDBCOMPARE_EXISTSOLDER	0x07000022	// Destination is Older
// Return codes for askreplace
#define ASKREPLACE_OVERWRITE	0
#define ASKREPLACE_SKIP			1
#define ASKREPLACE_ABORT		-1

// Callback for confirmation on whether a file should be overwritten
typedef PWInt32 __stdcall PWAskReplaceCallback(char *pszName, PWUInt32 compareFlag, char *srcModDate, char *destModDate, PWUInt32 *pOverwriteFlag, void *pvSession);
typedef PWAskReplaceCallback *PWAskReplaceCallbackPtr;
typedef PWInt32 (*PWSetAskReplaceCallbackProcType)(PWAskReplaceCallbackPtr pAskReplaceFunc);

PWDBLIB_API PWInt32 
PWDBImport(char *fileName, char *PalmDBName, char *CalFileName, PWInt16 PalmDBType, PWInt16 CSVFormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPosArray);

PWDBLIB_API PWInt32 
PWDBImportMulti(char *fileName, char *CalFileName, PWInt16 PalmDBType, PWInt16 CSVFormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPosArray, char ***outFilePaths, int *outFileCount);

PWDBLIB_API PWInt32 
PWDBImportToPWX(char *fileName, char *PalmDBName, char *CalFileName, PWInt16 PalmDBType, PWInt16 CSVFormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPosArray);

PWDBLIB_API PWInt32 
PWDBExport(char *PalmDBName, char *fileName, char *CalFileName, PWInt16 CSVFormatType, PWInt16 CSVEleFormat, PWInt16 CSVFieldCount, PWInt16 *CSVPosArray);

// ppInfo is an ptr to the address of an Array of PWPointInfoData. 
// Must be passed in as a NULL ptr
PWDBLIB_API PWInt32 
PWDBReadPDB(char *prcName, void **ppInfo, PWInt32 *pPalmFileType);

// pInfo is an Array of PWPointInfoData. 
PWDBLIB_API PWInt32 
PWDBWritePDB(char *prcName, void *pInfo, PWInt32 count, PWInt32 PalmFileType);

// ppInfo is an ptr to the address of an Array of PWPointInfoData. 
// Must be passed in as a NULL ptr
PWDBLIB_API PWInt32 
PWDBReadCSV(char *fileName, char *CalFileName, PWInt16 PalmDBType, PWInt16 FormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPos, void **ppInfo);

// pInfo is an Array of PWPointInfoData. 
PWDBLIB_API PWInt32 
PWDBWriteCSV(char *fileName, char *CalFileName, PWInt16 PalmDBType, PWInt16 FormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPos, void *pInfo, PWInt32 count);

// call this to release the memory allocated by PWDBReadPDB
PWDBLIB_API void 
PWDBRelease(void *pInfo, PWInt32 count);

PWDBLIB_API PWInt32 
PWDBCEEnum( char *pCHcmpPCPath, char *pCHpStoragePath, PWUInt32 flags, void **pResultArray );

PWDBLIB_API PWInt32 
PWDBCECopyToDevice( char *pCHpcName, char *pCHpStoragePath, PWUInt32 flags, char *CalFileName, PWInt16 PathAwayDBType, PWInt16 FormatType, PWInt16 CSVEleFormat, PWInt16 *CSVPos);

PWDBLIB_API PWInt32 
PWDBCECopyFromDevice( char *pCHpStoragePath, char *pCHfindname, char *pCHtoPCPath, PWUInt32 flags, char *CalFileName, PWInt16 PathAwayDBType, PWInt16 FormatType, PWInt16 CSVEleFormat, PWInt16 FieldCount, PWInt16 *CSVPos );

PWDBLIB_API PWInt32 
PWSetProgressCallback(PWProgressCallbackPtr pProgressFunc);

PWDBLIB_API PWInt32 
PWSetSessionPtr(void *pvSession);

PWDBLIB_API PWInt32 
PWGetPDBFileInfo(char *pdbName, PWUInt32 *pPalmDBType, PWUInt32 *pRecordFormatType,
			PWUInt32 *pPalmDBVersion, PWUInt32 *pPalmDBNumObj );

PWDBLIB_API PWInt32 
PWSetAskReplaceCallback(PWAskReplaceCallbackPtr pAskReplaceFunc);

PWDBLIB_API PWInt32 
PWGetCalFileTitle(char *CalFileName, char *CalFormatTitle, PWInt32 *plen);

PWDBLIB_API PWInt32 
PWGetCalFileInfo(char *infoStr, char *CalFileName, char *ppInfoData, PWInt32 *plen);

// List all of the Registered PathAway folder names
// version must be 0
// return: ppResultArray is a char * string list of null terminated folder names. This string is allocated by the library and 
// must be freed by the calling app
PWDBLIB_API PWInt32 
PWDBCEGetFolderInfo(PWUInt32 version,  void **ppResultArray );

// List all of the PathAway files in the folder, Wildcards accepted
// version must be 0
// return: ppResultArray is a char * string list of null terminated filenames. This string is allocated by the library and 
// must be freed by the calling app
PWDBLIB_API PWInt32 
PWDBCEFileEnum(PWUInt32 version,  char *pCHpStoragePath, PWUInt32 flags, void **ppResultArray );

// List all of the PathAway Database files in the folder
// Set PathAwayDBType to 0 for all types
// version must be 0
// ppResultArray is a char * string list of null terminated filenames. This string is allocated by the library and 
// must be freed by the calling app
PWDBLIB_API PWInt32 
PWDBCEDatabaseEnum(PWUInt32 version,  char *pCHpStoragePath, PWInt16 PathAwayDBType, PWUInt32 flags, void **ppResultArray );

// call this to release the memory allocated in ppResultArray
PWDBLIB_API PWInt32 
PWDBMemFree(void *pvData);

// flags for PWDBCEGetInfo
#define PROGRAMINFO_FLAG_GETSTATE 0

// Return Status for PROGRAMINFO_FLAG_GETSTATE
#define PROGRAMSTATE_INSTALLED 1
#define PROGRAMSTATE_RUNNING 2
// If pData is not NULL, then the program path is returned.

// Get Program Installed, Running State
PWDBLIB_API PWInt32 
PWDBCEGetInfo(PWUInt32 flags, PWUInt32 *pState, void *pData);

// Delete Maps and Data on Device.
PWDBLIB_API PWInt32 
PWDBCEDeleteFromDevice(char *pCHpStoragePath, char *pCHfindname, PWInt16 PathAwayDBType, PWUInt32 flags);
